#pragma once

const double MAX_DX_RES = 1024;
const double MAX_DY_RES = 768;

static const int MAX_ASTEROIDS = 30;
static const int MAX_SHOTS = 10;

class Asteroid
{
public:
	Asteroid();

	int m_x;    // Koordinaten des Mittelpunkts
	int m_y;
	int m_type; // 1 ... 4, uere Form
	int m_sf;   // scale factor: 0 = gro, 15 = mittel, 14 = klein
	int m_index;

	void set(int x, int y, int type, int sf);
};

class Shot
{
public:
	int m_x;
	int m_y;

	void set(int x, int y);
};

class GameStatus
{
public:
	bool m_ship_present;  // Schiff sichtbar
	int m_ship_x;         // Mittelpunkt des Schiffs
	int m_ship_y;
	int m_ship_dx;        // Blickrichtung des Schiffes
	int m_ship_dy;

	bool m_saucer_present;// UFO sichtbar
	int m_saucer_x;       // Mittelpunkt des UFOs
	int m_saucer_y;
	int m_saucer_size;    // Gre: 15 = gro, 14 = klein

	int m_nasteroids; // Anzahl Asteroiden
	Asteroid m_asteroids[MAX_ASTEROIDS];

	int m_nshots;     // Anzahl Schsse
	Shot m_shots[MAX_SHOTS];

	void clear(void);
};

#pragma pack(1)
struct FramePacket
{
	char m_vectorram[1024];
	char m_frameno;  // wird bei jedem Frame inkrementiert
	char m_ping;     // Der Server schickt das letzte empfangene ping-Byte zurck
};

class KeysPacket
{
public:
	static const char KEY_HYPERSPACE = 1;
	static const char KEY_FIRE = 2;
	static const char KEY_THRUST = 4;
	static const char KEY_RIGHT = 8;
	static const char KEY_LEFT = 0x10;

	char m_signature[6];
	char m_keys;

	char m_ping;     // wird vom Server bei nchster Gelegenheit zurckgeschickt. Fr Latenzmessung.

	KeysPacket(void);
	void clear(void);         // alle Tasten loslassen
	void hyperspace(bool b);  // Hyperspace drcken (true) oder loslassen (false)
	void fire(bool b);        // Feuerknopf drcken (true) oder loslassen (false)
	void thrust(bool b);      // Beschleunigen ...
	void right(bool b);       // rechts drehen ...
	void left(bool b);        // links drehen
};
#pragma pack()

